*___________________________________________________________________________________________________

	qbuild(dsIn=, dsOut, timeBase=)

	macro to build a dataset with quotes lined up in regular intervals.

	Parameters:
	dsIn		Input dataset (in same form as TAQ CQ dataset)
	dsOut		Output dataset.  The variables in this dataset are symbol, date, time and
				the bids and offers for the five exchanges:
				Nbid, Nofr, Pbid, Pofr, Xbid, Xofr, Mbid, Mofr, Tbid, Tofr.
				For Tbid and Tofr (Nasdaq), only the CASE quotes are used.
	timeBase	a Sas time interval (see the ETS documentation).
				This determines the time resolution of the quote record used in estimation.
				Examples:
				minute5	(default)	end of every five minutes
				minute				end of every minute
				second10			end of every ten seconds
				hour				end of every hour

	Note on missing values:
		This routine inserts a 'missing data' record at the end of each day to prevent proc model from
		constructing lags across days.
		Proc model can handle missing data, but proc varmax cannot.
		If you are going to be using proc varmax, you should comment out the final step
		of this macro.

____________________________________________________________________________________________________;
%macro qBuild(dsIn=cq, dsOut=qAll, timeBase=minute5);
%let nEx=5;
%let allEx=N P X M T;
%do i=1 %to 5;
	%let Ex&i = %scan(&allEx,&i);
	%put &&Ex&i;
%end;
data cq1;
	set &dsIn;
	retain lastNbid .;
	by date;
	if first.date then lastNbid=.;
	where (bid>0 and ofr>0);
	if ex='N' then do;
		Nbid = bid;
		Nofr = ofr;
		lastNbid=Nbid;
	end;
	%macro setEx(ex);
	if ex="&ex" and (ex^="T" or (ex="T" and mmid="CAES")) then do;
		&ex.bid = bid;
		&ex.ofr = ofr;
		if &ex.bid<.02 then &ex.bid=.;
		if &ex.ofr>1.9*lastNbid then &ex.ofr=.;
	end;
	%mend;
	%setEx(P);
	%setEx(X);
	%setEx(M);
	%setEx(T);
	keep symbol date time %do i=1 %to &nEx; &&Ex&i..bid &&Ex&i..ofr %end;;
	output;
	if last.date then do;
		time='23:59:59't;
		%do i=1 %to &nEx; 
			&&Ex&i..bid=-1;
			&&Ex&i..ofr=-1;
		%end;
		output;
	end;
	run;
proc expand data=cq1 (rename=(time=taqTime)) out=cq2 (rename=(time=i taqTime=time)) method=step;
	%do i=1 %to &nEx; 
		convert &&Ex&i..bid;
		convert &&Ex&i..ofr;
	%end;
	by symbol date;
	run;
data cq3;
	set cq2;
	where time<'16:30't;
	by symbol date time;
	if last.time then output;
proc expand data=cq3 (where=(NBid>0)) out=&dsOut to=&timebase method=step align=e;
	%do i=1 %to &nEx; 
		convert &&Ex&i..bid;
		convert &&Ex&i..ofr;
	%end;
	id time;
	by symbol date;
	run;
data &dsOut;
	set &dsOut;
	by symbol date;
	output;
	if last.date then do;
		%do i=1 %to &nEx; 
			&&Ex&i..bid=.;
			&&Ex&i..ofr=.;
		%end;
		output;
	end;
	format time time.;
	run;
%mend qBuild;
